//CF_QuickSwap v.1.0.6 by www.cartoonflow.com 
//CARTOONFLOW - August 2018

function __execDialog(localResourcePath_ui, uiPath_H1, uiPath_H2, uiPath_H3, uiPath_H4, uiPath_H5, uiPath_V1, uiPath_V2, uiPath_V3, uiPath_V4, uiPath_V5)
{
  var drawings = [];
  var timings = [];
  var drawingPath = '';
  var colName = '';
  var page = 0;
  var numButtons = 10; 
  var hasPageLabel = 'YES';
  var lastPageValue = 0; 
  var drawingFolderName = '';
  var useNatThumbnails = 'No';
  var magnifyFactor = 1;
  var curLayout = 'H1';
  var tempDir = specialFolders.temp;
  var settings = [curLayout, magnifyFactor, useNatThumbnails];
  var h_version = 0.0;
  this._getSettings = function ()
  {
    version_info = about.getVersionInfoStr()
    var ind_start = version_info.indexOf("version ");
    var ind_end = version_info.indexOf(" build");
  	var version_str = version_info.slice(ind_start + 8, ind_end-2);
    h_version = parseFloat(version_str)
    var settingsFile = new File(tempDir + '/quickswap_settings_1.0.6.ini');  
    if(settingsFile.exists)
    {
       settingsFile.open(FileAccess.ReadOnly);
       var settingsText = settingsFile.read(FileAccess.ReadOnly);
       settingsFile.close();
       var newArr2 = JSON.parse(settingsText);
       var newArrLen2 = newArr2.length;
       curLayout = newArr2[0];
       magnifyFactor = newArr2[1];
       useNatThumbnails = newArr2[2];
       settings[0] = curLayout;
       settings[1] = magnifyFactor;
       settings[2] = useNatThumbnails;
    }
    else
    {
      if (h_version >= 15)
      {
        useNatThumbnails = 'Yes';
        settings[2] = useNatThumbnails;
      }
      else
      {
        useNatThumbnails = 'No';    
      }         
    } 
  }
  this._setSettings = function ()
  {
    var settingsFile = new File(tempDir + '/quickswap_settings_1.0.6.ini'); 
    settingsFile.open(FileAccess.WriteOnly);
    settingsFile.write('[' + '"' + curLayout + '"' + ', ' + magnifyFactor + ', ' + '"' + useNatThumbnails + '"' +']');
    settingsFile.close();
  }
  this._showDrawingFolderName = function ()
  {
    if(drawingFolderName != '')
    {
      MessageBox.information(drawingFolderName); 
    }
  }
  this._exposeAllDrawingSubstitutions = function ()
  {
    scene.beginUndoRedoAccum("Expose All Drawings");
    var curFrame = frame.current();  
    var numSelLayers = Timeline.numLayerSel;
    for (var x = 0; x < numSelLayers; x++)
    {
      if (Timeline.selIsColumn(x))
      {
        colName = Timeline.selToColumn(x);  
      }
      var type = column.type(colName);  
      if (type == 'DRAWING')
      {  
        var drg_timings = column.getDrawingTimings(colName);
        drg_timings = drg_timings.sort(function(a,b) {return a-b}); 
        var drg_timingsLen = drg_timings.length;        
        drwgFrame = curFrame;
        for (i = 0;i<drg_timingsLen; i++)
        {
           column.setEntry(colName, 1, drwgFrame, drg_timings[i]);
           drwgFrame = drwgFrame+1;        
        }
      }  
    }  
    scene.endUndoRedoAccum();
  }
  this._setMagnifyFactor = function ()
  {
    if(magnifyFactor == 1)
    {
      magnifyFactor = 1.25;
    }
    else
    {
      if(magnifyFactor == 1.25)
      {
        magnifyFactor = 1.5;
      }
      else
      {
        if(magnifyFactor == 1.5)
        {
          magnifyFactor = 1.75;
        }  
        else
        {
          if(magnifyFactor == 1.75)
          {
            magnifyFactor = 2;
          }  
          else
          {
            if(magnifyFactor == 2)
            {
              magnifyFactor = 1;
            }      
          }      
        }  
      } 
    }
    this._setButtonSize();
    this._setSettings();
  }
  this._setUseNatThumbnailsVal = function ()
  {
    if(useNatThumbnails == 'Yes')
    {
       useNatThumbnails = 'No';
    }
    else
    {
      useNatThumbnails = 'Yes';    
    }
    this._updateButtons();
    this._setSettings();
  } 
  this._setButtonSize = function ()
  {
    if(magnifyFactor == 1)
    {
      if(curLayout == 'H1')
      {
        this._loadLayout_H1();
      }
      if(curLayout == 'H2')
      {
        this._loadLayout_H2();
      }
      if(curLayout == 'H3')
      {
        this._loadLayout_H3();
      }
      if(curLayout == 'H4')
      {
        this._loadLayout_H4();
      }  
      if(curLayout == 'V1')
      {
        this._loadLayout_V1();
      }
      if(curLayout == 'V2')
      {
        this._loadLayout_V2();
      }
      if(curLayout == 'V3')
      {
        this._loadLayout_V3();
      }
      if(curLayout == 'V4')
      {
        this._loadLayout_V4();
      }  
    }
    else
    {
      this.ui.Button_01.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
      this.ui.Button_01.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
      this.ui.Button_01.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46); 
      this.ui.Button_02.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
      this.ui.Button_02.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
      this.ui.Button_02.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);
      this.ui.Button_03.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
      this.ui.Button_03.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);      
      this.ui.Button_03.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);
      this.ui.Button_04.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
      this.ui.Button_04.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);      
      this.ui.Button_04.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);
      this.ui.Button_05.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
      this.ui.Button_05.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);      
      this.ui.Button_05.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);
      this.ui.Button_06.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
      this.ui.Button_06.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);      
      this.ui.Button_06.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);
      if(numButtons > 6)
      {                    
        this.ui.Button_07.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
        this.ui.Button_07.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
        this.ui.Button_07.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);      
        this.ui.Button_08.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
        this.ui.Button_08.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);    
        this.ui.Button_08.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);  
        this.ui.Button_09.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
        this.ui.Button_09.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50); 
        this.ui.Button_09.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);     
        this.ui.Button_10.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
        this.ui.Button_10.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);      
        this.ui.Button_10.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);
        if(numButtons > 10)
        {
          this.ui.Button_11.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
          this.ui.Button_11.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
          this.ui.Button_11.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);
          this.ui.Button_12.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
          this.ui.Button_12.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
          this.ui.Button_12.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);
          this.ui.Button_13.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
          this.ui.Button_13.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);      
          this.ui.Button_13.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);
          this.ui.Button_14.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
          this.ui.Button_14.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);      
          this.ui.Button_14.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);
          this.ui.Button_15.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
          this.ui.Button_15.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);      
          this.ui.Button_15.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);
          if(numButtons > 15)
          {
            this.ui.Button_16.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
            this.ui.Button_16.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);      
            this.ui.Button_16.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);
            this.ui.Button_17.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
            this.ui.Button_17.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
            this.ui.Button_17.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);      
            this.ui.Button_18.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
            this.ui.Button_18.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);    
            this.ui.Button_18.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);  
            this.ui.Button_19.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
            this.ui.Button_19.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50); 
            this.ui.Button_19.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);     
            this.ui.Button_20.minimumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);
            this.ui.Button_20.maximumSize = new QSize(magnifyFactor * 50, magnifyFactor * 50);      
            this.ui.Button_20.iconSize = new QSize(magnifyFactor * 46, magnifyFactor * 46);
          }  
        }   
      }     
    }
  }    
  this._setPages = function ()
  {
    lastPageValue = this._getLastPage(); 
    if(page > lastPageValue)
    {
      page = lastPageValue;
    } 
  }
  this._getLastPage = function()
  {
    var drawingsLen = drawings.length;   
    var newLastPage = Math.floor(drawingsLen/numButtons);
    if(drawingsLen > 0)
    {
      var newLastPageFloat = drawingsLen/numButtons;
      if(newLastPageFloat <= newLastPage)
      {
        newLastPage = newLastPage - 1;
      }
    }
    else
    {
      newLastPage = 0;
    }
    return newLastPage;
  }  
  this._loadLayout_H1 = function ()
  {
    this.ui.close();
    curLayout = 'H1';
    this.ui = UiLoader.load(uiPath_H1);
    numButtons = 10; 
    hasPageLabel = 'YES';
    this._connectUI();
    this.ui.layoutButton_01.released.connect(this, this._loadLayout_V1);
    this.ui.layoutButton_01.text = 'V';
    this.ui.layoutButton_01.toolTip = 'Vertical View';
    this.ui.plusButton.released.connect(this, this._loadLayout_H2);
    this.ui.expandButton.released.connect(this, this._loadLayout_H4);
    this.ui.expandButton.icon = new QIcon(localResourcePath_ui + "/icons/expand-h.png");
    this.ui.magnifyButton.released.connect(this, this._setMagnifyFactor);
    this.ui.magnifyButton.icon = new QIcon(localResourcePath_ui + "/icons/fieldglasses");
    this.ui.checkBox.released.connect(this, this._setUseNatThumbnailsVal); 
    if (h_version >= 15)
    {
      this.ui.folderButton.released.connect(this, this._exposeAllDrawingSubstitutions);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/exposeAllDrawingSubstitutions");
      this.ui.folderButton.toolTip = 'Expose All Drawing Substitutions';
    }
    else
    {            
      this.ui.folderButton.released.connect(this, this._showDrawingFolderName);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/folder");                
    }
    this.ui.show();
    this._setPages();
    this.ui.PAGE_label.text = " " + (page+1) + "/" + (lastPageValue+1); 
    if(useNatThumbnails == 'Yes')
    {
       this.ui.checkBox.checked = true;
    }
    else
    {
      this.ui.checkBox.checked = false;    
    }
    this._updateButtons();
    if(magnifyFactor > 1)
    {
      this._setButtonSize();   
    }
    this._setSettings();
  }  
  this._loadLayout_H2 = function ()
  {
    this.ui.close();
    curLayout = 'H2';
    this.ui = UiLoader.load(uiPath_H2);
    numButtons = 15; 
    hasPageLabel = 'YES';
    this._connectUI();
    this.ui.layoutButton_01.released.connect(this, this._loadLayout_V2);
    this.ui.layoutButton_01.text = 'V';
    this.ui.layoutButton_01.toolTip = 'Vertical View';
    this.ui.minusButton.released.connect(this, this._loadLayout_H1);
    this.ui.plusButton.released.connect(this, this._loadLayout_H3);
    this.ui.magnifyButton.released.connect(this, this._setMagnifyFactor);
    this.ui.magnifyButton.icon = new QIcon(localResourcePath_ui + "/icons/fieldglasses");
    this.ui.checkBox.released.connect(this, this._setUseNatThumbnailsVal); 
    if (h_version >= 15)
    {
      this.ui.folderButton.released.connect(this, this._exposeAllDrawingSubstitutions);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/exposeAllDrawingSubstitutions");
      this.ui.folderButton.toolTip = 'Expose All Drawing Substitutions';
    }
    else
    {            
      this.ui.folderButton.released.connect(this, this._showDrawingFolderName);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/folder");                
    }
    this.ui.show();
    this._setPages();
    this.ui.PAGE_label.text = " " + (page+1) + "/" + (lastPageValue+1); 
    if(useNatThumbnails == 'Yes')
    {
       this.ui.checkBox.checked = true;
    }
    else
    {
      this.ui.checkBox.checked = false;    
    }
    this._updateButtons();
    if(magnifyFactor > 1)
    {
      this._setButtonSize();   
    }
    this._setSettings();
  } 
  this._loadLayout_H3 = function ()
  {
    this.ui.close();
    curLayout = 'H3';
    this.ui = UiLoader.load(uiPath_H3);
    numButtons = 20; 
    hasPageLabel = 'YES';
    this._connectUI();
    this.ui.layoutButton_01.released.connect(this, this._loadLayout_V3);
    this.ui.layoutButton_01.text = 'V';
    this.ui.layoutButton_01.toolTip = 'Vertical View';
    this.ui.minusButton.released.connect(this, this._loadLayout_H2);
    this.ui.magnifyButton.released.connect(this, this._setMagnifyFactor);
    this.ui.magnifyButton.icon = new QIcon(localResourcePath_ui + "/icons/fieldglasses");
    this.ui.checkBox.released.connect(this, this._setUseNatThumbnailsVal); 
    if (h_version >= 15)
    {
      this.ui.folderButton.released.connect(this, this._exposeAllDrawingSubstitutions);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/exposeAllDrawingSubstitutions");
      this.ui.folderButton.toolTip = 'Expose All Drawing Substitutions';
    }
    else
    {            
      this.ui.folderButton.released.connect(this, this._showDrawingFolderName);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/folder");                
    }
    this.ui.show();
    this._setPages();
    this.ui.PAGE_label.text = " " + (page+1) + "/" + (lastPageValue+1); 
    if(useNatThumbnails == 'Yes')
    {
       this.ui.checkBox.checked = true;
    }
    else
    {
      this.ui.checkBox.checked = false;    
    }
    this._updateButtons();
    if(magnifyFactor > 1)
    {
      this._setButtonSize();   
    }
    this._setSettings();
  }  
  this._loadLayout_H4 = function ()
  {
    if(magnifyFactor > 1.25)
    {
      this._loadLayout_H5();    
    }
    else
    {
      this.ui.close();
      curLayout = 'H4';
      this.ui = UiLoader.load(uiPath_H4);
      numButtons = 10; 
      hasPageLabel = 'NO';
      this._connectUI();
      this.ui.collapseButton.released.connect(this, this._loadLayout_H1);
      this.ui.collapseButton.icon = new QIcon(localResourcePath_ui + "/icons/collapse-h.png");
      this.ui.checkBox.released.connect(this, this._setUseNatThumbnailsVal); 
      if (h_version >= 15)
      {
        this.ui.folderButton.released.connect(this, this._exposeAllDrawingSubstitutions);
        this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/exposeAllDrawingSubstitutions");
        this.ui.folderButton.toolTip = 'Expose All Drawing Substitutions';
      }
      else
      {            
        this.ui.folderButton.released.connect(this, this._showDrawingFolderName);
        this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/folder");                
      }
      this.ui.show();
      this._setPages();
      if(useNatThumbnails == 'Yes')
      {
         this.ui.checkBox.checked = true;
      }
      else
      {
        this.ui.checkBox.checked = false;    
      }
      this._updateButtons();
      if(magnifyFactor > 1)
      {
        this._setButtonSize();   
      }
      this._setSettings();
    }
  }  
  this._loadLayout_H5 = function ()
  {
    this.ui.close();
    curLayout = 'H5';
    this.ui = UiLoader.load(uiPath_H5);
    numButtons = 6; 
    hasPageLabel = 'NO';
    this._connectUI();
    this.ui.collapseButton.released.connect(this, this._loadLayout_H1);
    this.ui.collapseButton.icon = new QIcon(localResourcePath_ui + "/icons/collapse-h.png");
    this.ui.checkBox.released.connect(this, this._setUseNatThumbnailsVal); 
    if (h_version >= 15)
    {
      this.ui.folderButton.released.connect(this, this._exposeAllDrawingSubstitutions);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/exposeAllDrawingSubstitutions");
      this.ui.folderButton.toolTip = 'Expose All Drawing Substitutions';
    }
    else
    {            
      this.ui.folderButton.released.connect(this, this._showDrawingFolderName);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/folder");                
    }
    this.ui.show();
    this._setPages();
    if(useNatThumbnails == 'Yes')
    {
       this.ui.checkBox.checked = true;
    }
    else
    {
      this.ui.checkBox.checked = false;    
    }
    this._updateButtons();
    if(magnifyFactor > 1)
    {
      this._setButtonSize();   
    }
    this._setSettings();
  } 
  this._loadLayout_V1 = function ()
  {
    this.ui.close();
    curLayout = 'V1';
    this.ui = UiLoader.load(uiPath_V1);
    numButtons = 10; 
    hasPageLabel = 'YES';
    this._connectUI();
    this.ui.layoutButton_01.released.connect(this, this._loadLayout_H1);
    this.ui.layoutButton_01.text = 'H';
    this.ui.layoutButton_01.toolTip = 'Horizontal View';
    this.ui.plusButton.released.connect(this, this._loadLayout_V2);
    this.ui.expandButton.released.connect(this, this._loadLayout_V4);
    this.ui.expandButton.icon = new QIcon(localResourcePath_ui + "/icons/expand-v.png");
    this.ui.magnifyButton.released.connect(this, this._setMagnifyFactor);
    this.ui.magnifyButton.icon = new QIcon(localResourcePath_ui + "/icons/fieldglasses");
    this.ui.checkBox.released.connect(this, this._setUseNatThumbnailsVal); 
    if (h_version >= 15)
    {
      this.ui.folderButton.released.connect(this, this._exposeAllDrawingSubstitutions);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/exposeAllDrawingSubstitutions");
      this.ui.folderButton.toolTip = 'Expose All Drawing Substitutions';
    }
    else
    {            
      this.ui.folderButton.released.connect(this, this._showDrawingFolderName);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/folder");                
    }
    this.ui.show();
    this._setPages();
    this.ui.PAGE_label.text = " " + (page+1) + "/" + (lastPageValue+1); 
    if(useNatThumbnails == 'Yes')
    {
       this.ui.checkBox.checked = true;
    }
    else
    {
      this.ui.checkBox.checked = false;    
    }
    this._updateButtons();
    if(magnifyFactor > 1)
    {
      this._setButtonSize();   
    }
    this._setSettings();
  } 
  this._loadLayout_V2 = function ()
  {
    this.ui.close();
    curLayout = 'V2';
    this.ui = UiLoader.load(uiPath_V2);
    numButtons = 15; 
    hasPageLabel = 'YES';
    this._connectUI(); 
    this.ui.layoutButton_01.released.connect(this, this._loadLayout_H2);
    this.ui.layoutButton_01.text = 'H';
    this.ui.layoutButton_01.toolTip = 'Horizontal View';
    this.ui.minusButton.released.connect(this, this._loadLayout_V1);    
    this.ui.plusButton.released.connect(this, this._loadLayout_V3);
    this.ui.magnifyButton.released.connect(this, this._setMagnifyFactor);
    this.ui.magnifyButton.icon = new QIcon(localResourcePath_ui + "/icons/fieldglasses");
    this.ui.checkBox.released.connect(this, this._setUseNatThumbnailsVal); 
    if (h_version >= 15)
    {
      this.ui.folderButton.released.connect(this, this._exposeAllDrawingSubstitutions);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/exposeAllDrawingSubstitutions");
      this.ui.folderButton.toolTip = 'Expose All Drawing Substitutions';
    }
    else
    {            
      this.ui.folderButton.released.connect(this, this._showDrawingFolderName);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/folder");                
    }
    this.ui.show();
    this._setPages();
    this.ui.PAGE_label.text = " " + (page+1) + "/" + (lastPageValue+1); 
    if(useNatThumbnails == 'Yes')
    {
       this.ui.checkBox.checked = true;
    }
    else
    {
      this.ui.checkBox.checked = false;    
    }
    this._updateButtons();
    if(magnifyFactor > 1)
    {
      this._setButtonSize();   
    }
    this._setSettings();
  } 
  this._loadLayout_V3 = function ()
  {
    this.ui.close();
    curLayout = 'V3';
    this.ui = UiLoader.load(uiPath_V3);
    numButtons = 20; 
    hasPageLabel = 'YES';
    this._connectUI(); 
    this.ui.layoutButton_01.released.connect(this, this._loadLayout_H3);
    this.ui.layoutButton_01.text = 'H';
    this.ui.layoutButton_01.toolTip = 'Horizontal View';    
    this.ui.minusButton.released.connect(this, this._loadLayout_V2); 
    this.ui.magnifyButton.released.connect(this, this._setMagnifyFactor);
    this.ui.magnifyButton.icon = new QIcon(localResourcePath_ui + "/icons/fieldglasses");
    this.ui.checkBox.released.connect(this, this._setUseNatThumbnailsVal); 
    if (h_version >= 15)
    {
      this.ui.folderButton.released.connect(this, this._exposeAllDrawingSubstitutions);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/exposeAllDrawingSubstitutions");
      this.ui.folderButton.toolTip = 'Expose All Drawing Substitutions';
    }
    else
    {            
      this.ui.folderButton.released.connect(this, this._showDrawingFolderName);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/folder");                
    }  
    this.ui.show();
    this._setPages();
    this.ui.PAGE_label.text = " " + (page+1) + "/" + (lastPageValue+1); 
    if(useNatThumbnails == 'Yes')
    {
       this.ui.checkBox.checked = true;
    }
    else
    {
      this.ui.checkBox.checked = false;    
    }
    this._updateButtons();
    if(magnifyFactor > 1)
    {
      this._setButtonSize();   
    }
    this._setSettings();
  } 
  this._loadLayout_V4 = function ()
  {
    if(magnifyFactor > 1.25)
    {
      this._loadLayout_V5();    
    }
    else
    {
      this.ui.close();
      curLayout = 'V4';
      this.ui = UiLoader.load(uiPath_V4);
      numButtons = 10; 
      hasPageLabel = 'YES';
      this._connectUI(); 
      this.ui.collapseButton.released.connect(this, this._loadLayout_V1);
      this.ui.collapseButton.icon = new QIcon(localResourcePath_ui + "/icons/collapse-v.png");
      this.ui.prevButton.icon = new QIcon(localResourcePath_ui + "/icons/previous-v.png");
      this.ui.nextButton.icon = new QIcon(localResourcePath_ui + "/icons/next-v.png");  
      this.ui.checkBox.released.connect(this, this._setUseNatThumbnailsVal); 
      if (h_version >= 15)
      {
        this.ui.folderButton.released.connect(this, this._exposeAllDrawingSubstitutions);
        this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/exposeAllDrawingSubstitutions");
        this.ui.folderButton.toolTip = 'Expose All Drawing Substitutions';
      }
      else
      {            
        this.ui.folderButton.released.connect(this, this._showDrawingFolderName);
        this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/folder");                
      }
      this.ui.show();
      this._setPages();
      this.ui.PAGE_label.text = " " + (page+1) + "/" + (lastPageValue+1); 
      if(useNatThumbnails == 'Yes')
      {
         this.ui.checkBox.checked = true;
      }
      else
      {
        this.ui.checkBox.checked = false;    
      }
      this._updateButtons();
      if(magnifyFactor > 1)
      {
        this._setButtonSize();   
      }
    this._setSettings();
    }
  }
  this._loadLayout_V5 = function ()
  {
    this.ui.close();
    curLayout = 'V5';
    this.ui = UiLoader.load(uiPath_V5);
    numButtons = 6; 
    hasPageLabel = 'YES';
    this._connectUI(); 
    this.ui.collapseButton.released.connect(this, this._loadLayout_V1);
    this.ui.collapseButton.icon = new QIcon(localResourcePath_ui + "/icons/collapse-v.png");
    this.ui.prevButton.icon = new QIcon(localResourcePath_ui + "/icons/previous-v.png");
    this.ui.nextButton.icon = new QIcon(localResourcePath_ui + "/icons/next-v.png");  
    this.ui.checkBox.released.connect(this, this._setUseNatThumbnailsVal); 
    if (h_version >= 15)
    {
      this.ui.folderButton.released.connect(this, this._exposeAllDrawingSubstitutions);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/exposeAllDrawingSubstitutions");
      this.ui.folderButton.toolTip = 'Expose All Drawing Substitutions';
    }
    else
    {            
      this.ui.folderButton.released.connect(this, this._showDrawingFolderName);
      this.ui.folderButton.icon = new QIcon(localResourcePath_ui + "/icons/folder");                
    }
    this.ui.show();
    this._setPages();
    this.ui.PAGE_label.text = " " + (page+1) + "/" + (lastPageValue+1); 
    if(useNatThumbnails == 'Yes')
    {
       this.ui.checkBox.checked = true;
    }
    else
    {
      this.ui.checkBox.checked = false;    
    }
    this._updateButtons();
    if(magnifyFactor > 1)
    {
      this._setButtonSize();   
    }
    this._setSettings();
  }
  this._reloadDrawings = function ()
  {
    page = 0;
    colName = ''; 
    this._getDrawings();
    this._updateButtons(); 
    var lastPageValue = this._getLastPage(); 
    if(hasPageLabel == 'YES')
    {
      this.ui.PAGE_label.text = " " + (page+1) + "/" + (lastPageValue+1);     
    }
    else
    {
      return;    
    }
  }  
  this._sortNumber = function (a,b)
  {
    return a-b;
  }
  this._setSubstitution_01 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[0 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[0 + (page*numButtons)]);
      } 
    } 
  } 
  this._setSubstitution_02 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[1 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[1 + (page*numButtons)]);
      } 
    }  
  } 
  this._setSubstitution_03 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[2 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[2 + (page*numButtons)]); 
      } 
    }  
  }   
  this._setSubstitution_04 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[3 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[3 + (page*numButtons)]); 
      } 
    }    
  } 
  this._setSubstitution_05 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[4 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[4 + (page*numButtons)]); 
      } 
    }    
  } 
  this._setSubstitution_06 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[5 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[5 + (page*numButtons)]);
      } 
    }  
  } 
  this._setSubstitution_07 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[6 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[6 + (page*numButtons)]);
      } 
    }  
  }   
  this._setSubstitution_08 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[7 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[7 + (page*numButtons)]);
      } 
    }    
  } 
  this._setSubstitution_09 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[8 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[8 + (page*numButtons)]);
      } 
    }    
  } 
  this._setSubstitution_10 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[9 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[9 + (page*numButtons)]);
      } 
    }  
  }
  this._setSubstitution_11 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[10 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[10 + (page*numButtons)]);
      } 
    } 
  } 
  this._setSubstitution_12 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[11 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[11 + (page*numButtons)]);
      } 
    }  
  } 
  this._setSubstitution_13 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[12 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[12 + (page*numButtons)]);
      } 
    }  
  }   
  this._setSubstitution_14 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[13 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[13 + (page*numButtons)]);
      } 
    }    
  } 
  this._setSubstitution_15 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[14 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[14 + (page*numButtons)]);
      } 
    }    
  }  
  this._setSubstitution_16 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[15 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[15 + (page*numButtons)]);
      } 
    }  
  } 
  this._setSubstitution_17 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[16 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[16 + (page*numButtons)]);
      } 
    }  
  }   
  this._setSubstitution_18 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[17 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[17 + (page*numButtons)]);
      } 
    }    
  } 
  this._setSubstitution_19 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[18 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[18 + (page*numButtons)]);
      } 
    }    
  } 
  this._setSubstitution_20 = function ()
  {
    var curFrame = frame.current();
    if(colName != '')
    {
      if(timings[19 + (page*numButtons)])
      {
        column.setEntry(colName, 1, curFrame, timings[19 + (page*numButtons)]);
      } 
    }  
  }
  this._getDrawings = function ()
  {  
    drawings = [];
    timings = [];
    drawingFolderName = '';
    var curProjPath = scene.currentProjectPath();
    var numSelLayers = Timeline.numLayerSel;
    if(numSelLayers > 0)
    {
      if(Timeline.selIsColumn(0))
      {
        colName = Timeline.selToColumn(0);
        layName = Timeline.selToLayer(0);
        fullNodeName = Timeline.selToNode(0);
        var nodeName = fullNodeName.slice(fullNodeName.indexOf("/") + 1);               
        var displayName = column.getDisplayName(colName);
        var type = column.type(colName);
        if (type == "DRAWING")
        {
          var elID = column.getElementIdOfDrawing(colName);        
          var elFolder = element.folder(elID);
          var elCompleteFolder = element.completeFolder(elID);
          var elPhysName = element.physicalName(elID);
          drawingFolderName = elFolder;
          var layerName = node.getTextAttr(fullNodeName, 1, "drawing.element.layer");          
          var drawingName = ''         
          if  (layerName == "")
          {
            drawingName = elPhysName
          }
          else
          {
             drawingName = layerName
          }      
          var mappedPath = fileMapper.toNativePath(element.completeFolder(elID));    
          drawingPath = mappedPath + '/'; 
          timings = column.getDrawingTimings(colName);
          timings = timings.sort(function(a,b) {return a-b}); 
          var timingsLen = timings.length;
          for (i = 0; i < timingsLen; i++)
          {
            var dr = [];
            dr.push(elPhysName + '-' + timings[i]);
            dr.push(drawingName + '-' + timings[i]);
            dr.push('');
            drawings.push( dr );
          }
          var drawingsLen = drawings.length;
          var formats = ['jpg', 'jpeg', 'bmp', 'png', 'tga', 'psd', 'tiff', 'sgi', 'omf', 'pal', 'scan', 'tvg', 'svg', 'pdf', 'ai'];
          var forLen = formats.length;
          var drawingsLen = drawings.length;
          for(i = 0; i < drawingsLen; i++)
          {
            for(var f = 0; f < forLen; f++)
            {
              var createThumb = 'No';
              var filePath = drawingPath + drawings[i][1]  + '.' + formats[f];
              var img = new File(filePath);  
              if(img.exists)
              {
                createThumb = 'Yes';
                drawings[i][0] = drawings[i][1];
              }
              else
              {
                var filePath = drawingPath + drawings[i][0]  + '.' + formats[f];
                var img = new File(filePath); 
                if(img.exists)
                {
                  createThumb = 'Yes';
                }               
              }
              if(createThumb == 'Yes')
              {
                var sourcefile = filePath; 
                drawings[i][2] = formats[f]; 
                  if (useNatThumbnails == 'No')
                  {
                    var outfile = drawingPath + '.quickswap_thumbnails/' + drawings[i][0]  + '.png';
                    if(formats[f] == 'tvg' || formats[f] == 'svg' || formats[f] == 'ai' || formats[f] == 'pdf')
                    {
                      width = 1000;
                      height = 1000; 
                    }
                    else
                    {
                      width = 100;
                      height = 100; 
                    }                
                    var ret = Utransform("-resolution", width, height, "-antialiasing", "high", "1", "-outformat", "PNG4", "-crop",  "-bgalpha", 0, "-outfile", outfile, sourcefile);
                    var str_cropResolutionX = ret.slice(ret.indexOf("cropResolutionX=") + 17, ret.indexOf('" cropResolutionY='));               
                    var str_cropResolutionY = ret.slice(ret.indexOf("cropResolutionY=") + 17, ret.indexOf('" enlargePixel'));               
                    if(str_cropResolutionX != '')
                    {
                      var cropResolutionX = parseInt(str_cropResolutionX, 10);                
                      var cropResolutionY = parseInt(str_cropResolutionY, 10);
                      if(cropResolutionX > 100 || cropResolutionY > 100)
                      {
                        var information1 = '--- Image is already higher or broader than 100 px ---';
                        var information2 = '--- Single Utransform Pass ---';
                      }
                      else 
                      {
                        if(cropResolutionX > cropResolutionY)
                        {
                          ratio = 200 / cropResolutionX;  
                        }
                        else
                        {
                          ratio = (200 / cropResolutionY);
                        }
                        width = Math.ceil(1000*ratio);
                        height = Math.ceil(1000*ratio); 
                        var ret2 = Utransform("-resolution", width, height, "-antialiasing", "high", "1", "-outformat", "PNG4", "-crop", "-bgalpha", 0, "-outfile", outfile, sourcefile);                
                      }                    
                    }
                    else
                    {
                      var information1 = '--- cropResolutionX has no value ---';
                      var information2 = '--- Single Utransform Pass ---';
                    }                    
                  }  
              }  
            } 
          }
        }
      }
    }
  }
  this._nextPage = function ()
  {
    var drawingsLen = drawings.length;
    if( drawingsLen > (page * numButtons) + numButtons)
    {
      page = page + 1;
    }
    this._updateButtons();
    lastPageValue = this._getLastPage(); 
    if(hasPageLabel == 'YES')
    {
      this.ui.PAGE_label.text = " " + (page+1) + "/" + (lastPageValue+1);     
    }
    else
    {
      return;    
    }         
  }
  this._prevPage = function ()
  {
    var drawingsLen = drawings.length;
    if( page > 0)
    {
      page = page - 1;
    }
    this._updateButtons();
    lastPageValue = this._getLastPage(); 
    if(hasPageLabel == 'YES')
    {
      this.ui.PAGE_label.text = " " + (page+1) + "/" + (lastPageValue+1);     
    }
    else
    {
      return;    
    }      
  }
  this._updateButtons = function ()
  {  
    var drawingsLen = drawings.length;
    buttons = [
              this.ui.Button_01,
              this.ui.Button_02,
              this.ui.Button_03,
              this.ui.Button_04,
              this.ui.Button_05,
              this.ui.Button_06,   
              this.ui.Button_07,
              this.ui.Button_08,
              this.ui.Button_09,
              this.ui.Button_10,
              this.ui.Button_11,
              this.ui.Button_12,      
              this.ui.Button_13,
              this.ui.Button_14,
              this.ui.Button_15,
              this.ui.Button_16,   
              this.ui.Button_17,
              this.ui.Button_18,
              this.ui.Button_19,
              this.ui.Button_20,
              ]
    buttonsLen = buttons.length;
    for(i = 0; i < numButtons; i++)
    {       
        buttons[i].icon = new QIcon(''); 
        buttons[i].toolTip = '';
    }
    for(i = 0 + (page*numButtons); i < drawingsLen; i++)
    {
      for(a = 0; a < buttonsLen; a++)
      {
        if(numButtons < 11)
        {
          if(a > 9)
          {
            break;          
          }
        }
        if(numButtons < 16)
        {
          if(a > 14)
          {
            break;          
          }
        }
        if(numButtons < 21)
        {
          if(a > 19)
          {
            break;          
          }
        }   
        if(i == a + (page*numButtons))
        {
          var thumbnail = drawingPath + '.quickswap_thumbnails/' + drawings[i][0]  + '.png';
            if(useNatThumbnails == 'Yes')
            {
              var natThumbnail = drawingPath + '.thumbnails/' + '.' + drawings[i][0] + '.' + drawings[i][2]  + '.png';
              var natThumbFile = new File(natThumbnail);  
              if(natThumbFile.exists)
              {
                 buttons[a].icon = new QIcon(natThumbnail);
              }
              else
              {
                if (h_version < 15)
                {
                   buttons[a].icon = new QIcon(thumbnail);
                }
               else
               {
                   buttons[a].icon = new QIcon(localResourcePath_ui + "/icons/blank_thumbnail.png");
               }   
              }              
            }
            else
            { 
              buttons[a].icon = new QIcon(thumbnail);
            }
          buttons[a].toolTip = drawings[i][0];
        }
      }
    }
  }
  this.ui = UiLoader.load(uiPath_H1);
  this._connectUI = function ()
  {
    this.ui.loadButton.released.connect(this, this._reloadDrawings); 
    this.ui.loadButton.icon = new QIcon(localResourcePath_ui + "/icons/reload.png");
    this.ui.prevButton.released.connect(this, this._prevPage);    
    this.ui.prevButton.icon = new QIcon(localResourcePath_ui + "/icons/previous.png");
    this.ui.nextButton.released.connect(this, this._nextPage);    
    this.ui.nextButton.icon = new QIcon(localResourcePath_ui + "/icons/next.png");
    this.ui.Button_01.released.connect(this, this._setSubstitution_01);
    this.ui.Button_02.released.connect(this, this._setSubstitution_02);
    this.ui.Button_03.released.connect(this, this._setSubstitution_03);
    this.ui.Button_04.released.connect(this, this._setSubstitution_04); 
    this.ui.Button_05.released.connect(this, this._setSubstitution_05);
    this.ui.Button_06.released.connect(this, this._setSubstitution_06);
    if(numButtons > 6)
    {         
      this.ui.Button_07.released.connect(this, this._setSubstitution_07);
      this.ui.Button_08.released.connect(this, this._setSubstitution_08);
      this.ui.Button_09.released.connect(this, this._setSubstitution_09);
      this.ui.Button_10.released.connect(this, this._setSubstitution_10);
      if(numButtons > 10)
      {
        this.ui.Button_11.released.connect(this, this._setSubstitution_11);
        this.ui.Button_12.released.connect(this, this._setSubstitution_12);
        this.ui.Button_13.released.connect(this, this._setSubstitution_13);
        this.ui.Button_14.released.connect(this, this._setSubstitution_14);
        this.ui.Button_15.released.connect(this, this._setSubstitution_15); 
        if(numButtons > 15)
        {
          this.ui.Button_16.released.connect(this, this._setSubstitution_16);
          this.ui.Button_17.released.connect(this, this._setSubstitution_17);
          this.ui.Button_18.released.connect(this, this._setSubstitution_18);
          this.ui.Button_19.released.connect(this, this._setSubstitution_19);
          this.ui.Button_20.released.connect(this, this._setSubstitution_20);    
        }
      }     
    }
  } 
  this._getSettings();
  curLayout = settings[0];
  magnifyFactor = settings[1]; 
  useNatThumbnails = settings[2];
  if(curLayout == 'H1')
  {
    this._loadLayout_H1();  
  }
  if(curLayout == 'H2')
  {
    this._loadLayout_H2();  
  }
  if(curLayout == 'H3')
  {
    this._loadLayout_H3();  
  }
  if(curLayout == 'H4')
  {
    this._loadLayout_H4();  
  }
  if(curLayout == 'H5')
  {
    this._loadLayout_H5();  
  }
  if(curLayout == 'V1')
  {
    this._loadLayout_V1();  
  }
  if(curLayout == 'V2')
  {
    this._loadLayout_V2();  
  }
  if(curLayout == 'V3')
  {
    this._loadLayout_V3();  
  }
  if(curLayout == 'V4')
  {
    this._loadLayout_V4();  
  }
  if(curLayout == 'V5')
  {
    this._loadLayout_V5();  
  }
  if(hasPageLabel == 'YES')
  {
    this.ui.PAGE_label.text = " 1/1";     
  }
}
function CF_QuickSwap()
{
  //This piece of code is based William Saito's script 'Selection Sets 2.0' - START// 
  //The scipt can be downloaded at https://toonboomscripts.com/2016/03/29/selection-sets-2/
  if(specialFolders.userConfig.indexOf("USA_DB") != -1)
  {
  	localPath = fileMapper.toNativePath(specialFolders.userConfig);
  	var idxOf = localPath.indexOf("users");
  	localPath_ui = localPath.slice(0, idxOf) + "scripts";
  }
  else
  {
  	localPath = specialFolders.userConfig;
  	var idxOf_full = localPath.indexOf("full-");
  	var version = localPath.slice(idxOf_full + 5, -5);
  	localPath_ui = localPath.replace("/full-" + version + "-pref","/" + version +"-scripts");
  }
  //This piece of code is based William Saito's script 'Selection Sets 2.0' - END// 
  localResourcePath_ui = localPath_ui + "/CF_QuickSwap-Resources/v.1.0.6";
  var uiFile_H1 = 'QuickSwap_H1.ui';
  var uiFile_H2 = 'QuickSwap_H2.ui';
  var uiFile_H3 = 'QuickSwap_H3.ui';
  var uiFile_H4 = 'QuickSwap_H4.ui';
  var uiFile_H5 = 'QuickSwap_H5.ui';
  var uiFile_V1 = 'QuickSwap_V1.ui';
  var uiFile_V2 = 'QuickSwap_V2.ui';
  var uiFile_V3 = 'QuickSwap_V3.ui';
  var uiFile_V4 = 'QuickSwap_V4.ui';
  var uiFile_V5 = 'QuickSwap_V5.ui';
  var uiPath_H1 = localResourcePath_ui + "/" + uiFile_H1;
  var uiPath_H2 = localResourcePath_ui + "/" + uiFile_H2; 
  var uiPath_H3 = localResourcePath_ui + "/" + uiFile_H3; 
  var uiPath_H4 = localResourcePath_ui + "/" + uiFile_H4; 
  var uiPath_H5 = localResourcePath_ui + "/" + uiFile_H5; 
  var uiPath_V1 = localResourcePath_ui + "/" + uiFile_V1;
  var uiPath_V2 = localResourcePath_ui + "/" + uiFile_V2; 
  var uiPath_V3 = localResourcePath_ui + "/" + uiFile_V3;
  var uiPath_V4 = localResourcePath_ui + "/" + uiFile_V4; 
  var uiPath_V5 = localResourcePath_ui + "/" + uiFile_V5;   
  var resourceFilesArr = [uiFile_H1, uiFile_H2, uiFile_H3, uiFile_H4, uiFile_H5, uiFile_V1, uiFile_V2, uiFile_V3, uiFile_V4, uiFile_V5];
  var missingFilesArr = [];
  for(e = 0; e < resourceFilesArr.length; e++)
  {
    var uif = new File(localResourcePath_ui + "/" + resourceFilesArr[e]);
    if( !uif.exists )
    {
       missingFilesArr.push(resourceFilesArr[e])
    }  
  }
  if(missingFilesArr.length > 0)
  {
    var msgList = 'The following files were not found:' + '\n'
    for(e = 0; e < missingFilesArr.length; e++)
    {
      msgList = msgList + '- ' + missingFilesArr[e]  + '\n';    
    }
    MessageBox.information( msgList + '\n' +  'Please paste the file(s) into the following directory:' + '\n' + '\n' +  localResourcePath_ui + '/');
    return;  
  }
  var f = new __execDialog(localResourcePath_ui, uiPath_H1, uiPath_H2, uiPath_H3, uiPath_H4, uiPath_H5, uiPath_V1, uiPath_V2, uiPath_V3, uiPath_V4, uiPath_V5);
  f.ui.show();    
} 
