//CF_SetCompositeModes v.1.01 by www.cartoonflow.com 
//CARTOONFLOW - 2016
function __execDialog(uiPath)
{  
  this.fillComboBox = function ()
  {  
    this.ui.GroupBox_1.ComboBox.addItem('As Bitmap');
    this.ui.GroupBox_1.ComboBox.addItem('As Seamless Bitmap');
    this.ui.GroupBox_1.ComboBox.addItem('As Vector');
    this.ui.GroupBox_1.ComboBox.addItem('Pass Through');
  }
  
  this.fillComboBox_2 = function ()
  {  
    this.ui.GroupBox_2.ComboBox_2.addItem('2D');
    this.ui.GroupBox_2.ComboBox_2.addItem('3D flat');
    this.ui.GroupBox_2.ComboBox_2.addItem('3D');
  }
  
  

  this.setCompositeMode = function ()
  {
    scene.beginUndoRedoAccum("Set Composite Mode");
    var selLen = selection.numberOfNodesSelected();
     
    for (var i = 0 ; i < selLen; i++)
    {
      var n = selection.selectedNode(i);
      var nodeName = node.getName(n);
      var type = node.type(n);
    
      if (type == 'COMPOSITE')
      {
        var compMode =  this.ui.GroupBox_1.ComboBox.currentText;
        MessageLog.trace(nodeName + ' is COMPOSITE'); 
        node.setTextAttr(n, "COMPOSITE_MODE", 1, compMode);    
      }    
    }
    scene.endUndoRedoAccum();
  }
  
  
  
  this.setInputOrdering = function ()
  {
    scene.beginUndoRedoAccum("Set Input Ordering");
    var selLen = selection.numberOfNodesSelected();
     
    for (var i = 0 ; i < selLen; i++)
    {
      var n = selection.selectedNode(i);
      var nodeName = node.getName(n);
      var type = node.type(n);
    
      if (type == 'COMPOSITE')
      {
        var inputOrdering =  this.ui.GroupBox_2.ComboBox_2.currentText;
        MessageLog.trace(nodeName + ' is COMPOSITE'); 
      
        if(inputOrdering  == '2D')
        {
          node.setTextAttr(n, "COMPOSITE_2D", 1, 'Y');
          node.setTextAttr(n, "COMPOSITE_3D", 1, 'N');         
        }
        
        if(inputOrdering  == '3D flat')
        {
          node.setTextAttr(n, "COMPOSITE_2D", 1, 'N');
          node.setTextAttr(n, "COMPOSITE_3D", 1, 'N');         
        }
        
        if(inputOrdering  == '3D')
        {
          node.setTextAttr(n, "COMPOSITE_2D", 1, 'N');
          node.setTextAttr(n, "COMPOSITE_3D", 1, 'Y');         
        }
   
      }    
    }
    scene.endUndoRedoAccum();
  }
  
  this.ui = UiLoader.load(uiPath);
  this.ui.GroupBox_1.SetCompositeMode_Button.released.connect(this, this.setCompositeMode);
  this.ui.GroupBox_2.SetInputOrdering_Button.released.connect(this, this.setInputOrdering);
  
  this.fillComboBox();
  this.fillComboBox_2();



}


function CF_SetCompositeMode()
{
  MessageLog.trace("specialFolders.userConfig = " + specialFolders.userConfig);
  
  
  //This piece of code is based William Saito's script 'Selection Sets 2.0' - START// 
  //The scipt can be downloaded at https://toonboomscripts.com/2016/03/29/selection-sets-2/
  if(specialFolders.userConfig.indexOf("USA_DB") != -1)
  {
  	localPath = fileMapper.toNativePath(specialFolders.userConfig);
  	var idxOf = localPath.indexOf("users");
  	localPath_ui = localPath.slice(0, idxOf) + "scripts";
    MessageLog.trace("--- USA_DB ---");
  }
  else
  {
  	localPath = specialFolders.userConfig;
  	var idxOf_full = localPath.indexOf("full-");
  	var version = localPath.slice(idxOf_full + 5, -5);
  	localPath_ui = localPath.replace("/full-" + version + "-pref","/" + version +"-scripts");
    MessageLog.trace("--- NO USA_DB ---");
  }
  //This piece of code is based William Saito's script 'Selection Sets 2.0' - END// 
  
  MessageLog.trace("localPath_ui = " + localPath_ui);
  
  var uiFile = 'CF_SetCompositeMode.ui';
  var uiPath = localPath_ui + "/" + uiFile;



  var uif = new File(uiPath);
  if( !uif.exists )
  {
    MessageBox.information('"' + uiFile + '"' + ' file not found.' + '\n'  + '\n' +  'Please paste the file into the following directory:' + '\n' + '\n' +  localPath_ui + '/');
    return;
  }
  

  var f = new __execDialog(uiPath);
  f.ui.show();
}